'Jesse Ruderman's Visual Basic Module Library
'** - I know I need to mess with the size of the buffers
Option Explicit
DefInt A-Z
  Declare Function GetPrivateProfileString Lib "Kernel" (ByVal Appname As String, ByVal KeyName As String, ByVal DEFAULT As String, ByVal ReturnedString As String, ByVal MaxSize As Integer, ByVal FileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal Appname As String, ByVal KeyName As String, ByVal NewString As String, ByVal FileName As String)


Global IniFileName As String
'String.bas required in project

'IniFileName must be set to something like "MyIni.INI"
'in sub main or form_load

'"MyIni.ini", "\windows\myini.ini", "myini" are interchangable

'empty variants produce errors.
'String, integer, single, double, null ("") work.
'Date works but returns a string if default is not of vartype V_DATE.
'Currency works but returns a double.  Is this a problem?

'Sub writeINI (SecName$, KeyName$, St As Variant)
'Function readINI (SecName$, KeyName$, Def As Variant) As Variant

Function GoodIniFileName ()
Dim x

'prevent error from occuring in KERNEL.
If IniFileName = "" Then
 MsgBox "IniFileName not set in form_load or sub main", MB_ICONSTOP, "error in module IniFile2.bas"
 GoodIniFileName = False
 GoTo ExitFunction
End If

'Add .ini extension if not there
If FN_GetExt(IniFileName) = "" Then IniFileName = IniFileName + ".ini"

GoodIniFileName = True

ExitFunction:
End Function

Function readINI (SecName$, KeyName$, def As Variant) As Variant
Dim o As String, x As Integer, D$
o = String$(40, " ")

If Not GoodIniFileName() Then Exit Function
 
Select Case VarType(def)
 Case V_STRING
  D$ = def
 Case V_INTEGER, V_SINGLE, V_DOUBLE, V_CURRENCY
  D$ = Trim$(Str$(def))
 Case V_NULL  '**
  D$ = ""
 Case V_CURRENCY
  MsgBox "Currency variant not supported by readINI!", MB_ICONEXCLAMATION
  Stop
 Case V_DATE
  D$ = def
 Case V_EMPTY
  MsgBox "Default value is empty!", MB_ICONEXCLAMATION
  Stop
Case Else
  MsgBox "Variant type not recognized: " + Trim$(Str$(VarType(def))), MB_ICONEXCLAMATION
  Stop
End Select

x = GetPrivateProfileString(SecName$, KeyName$, D$, o, Len(o), IniFileName)

'I don't know why I have to do this
If InStr(o, Chr$(0)) Then o = Left$(o, InStr(o, Chr$(0)) - 1)
o = Trim$(o)

readINI = o
If VarType(def) = V_DATE Then readINI = DateValue(o)
'If default is a date, return a date.

End Function

Sub writeINI (SecName$, KeyName$, st As Variant)
Dim x, D$


If Not GoodIniFileName() Then Exit Sub

Select Case VarType(st)
 Case V_STRING
  D$ = st
 Case V_INTEGER, V_SINGLE, V_DOUBLE, V_CURRENCY
  D$ = Trim$(Str$(st))
 Case V_NULL  '**
  D$ = ""
 Case V_DATE
  D$ = st
 Case V_EMPTY
  MsgBox "Default value is empty!", MB_ICONEXCLAMATION
  Stop
Case Else
  MsgBox "Variant type not recognized: " + Trim$(Str$(VarType(st))), MB_ICONEXCLAMATION
  Stop
End Select
  
x = WritePrivateProfileString(SecName$, KeyName$, D$, IniFileName)
If (x = 0) Then MsgBox ("writeINI not succesful")
End Sub

